# Recent advances in acoustofluidic separation technology in biology

Yanping Fan1 , Xuan Wang1,2, Jiaqi Ren2 , Francis Lin3 and Jiandong Wu 2✉ D

# Abstract

Acoustofluidic separation of cells and particles is an emerging technology that integrates acoustics and microfluidics. In the last decade, this technology has attracted significant attention due to its biocompatible, contactless, and labelfree nature. It has been widely validated in the separation of cells and submicron bioparticles and shows great potential in different biological and biomedical applications. This review first introduces the theories and mechanisms of acoustofluidic separation. Then, various applications of this technology in the separation of biological particles such as cells, viruses, biomolecules, and exosomes are summarized. Finally, we discuss the challenges and future prospects of this field.

# Introduction

The separation of specific substances from mixtures has been applied in many fields, such as biological research1 , chemical analysis2 , and disease diagnosis3 . Over the past decades, attention has been drawn to the separation of cells and bioparticles for different biological and biomedical applications. The diagnosis of certain diseases is determined by detecting relevant pathogens or cells, and the effective separation of these particles is an important basis for accurate detection. For a long time, several traditional separation technologies have been applied to accomplish this task4 . The density gradient centrifugal separation method applies a centrifugal force to separate by size and density5 . However, it is time-consuming and can lead to substantial cell loss and alter cell functions. The immuno-magnetic bead separation method is another widely used separation technology that separates cells based on the antigen-antibody reaction6 . However, the lack of specific antibodies for certain cells makes this method not universal. New cell or particle separation methods are needed to overcome the limitations of these traditional technologies. Microfluidic devices have been recognized as a promising method to accomplish this task7 . These devices can be roughly classified into two categories according to separation principle: passive methods and active methods. Methods that utilize a specially designed channel or fluid flow to change the trajectory of particles are referred to as passive separation methods, which include microstructural filtration, hydraulic, deterministic lateral migration, and inertiabased separation methods8 . Active separation methods use an additional field (e.g., electrical, magnetic, acoustic, and optical fields) to generate a force that is exerted on particles and cells to achieve separation9 . In general, passive methods require simpler equipment, while active methods achieve higher separation efficiency.

Acoustofluidics is an emerging technology that integrates acoustic waves with microfluidic systems to manipulate fluids and particles in microstructures. The concept of acoustofluidics was first proposed by Henrik Bruus in $2 0 0 8 ^ { 1 0 }$ . He also made significant contributions to the theories of acoustofluidic separation over the following years11–13. The acoustofluidic method can separate different particles based on their physical properties, such as size14, density15 and compressibility16. Due to its labelfree17, contactless18, and biocompatible features19, the acoustofluidic method has been recognized as a promising technology for the separation and manipulation of cells and bioparticles. One advantage of acoustofluidic technology is that it allows separation in a variety of fluid media due to the good penetrability of sound waves, whereas optical force-based methods are often affected by fluid properties such as transparency and turbidity. In addition, a wide range of acoustic frequencies $\mathbf { ( 1 ~ k H z { - } } 5 0 0$ MHz) provides flexibility for different separation applications. Several previously reported reviews have nicely summarized acoustofluidic technologies and their bioapplications4,20–23. Instead of covering a broad range of applications in the biomedical/bioanalytical fields, this review mainly focuses on the acoustofluidic separation of cells and bionanoparticles, which can provide more relevant information for readers interested in this specific field. Compared with those reviews that also focus on particle separation, this paper was intended to provide more systematic and complete knowledge about the theories and mechanisms of separation, which may help readers, especially those new to the field, gain a more comprehensive understanding of this technology. Furthermore, this paper was updated with the latest literature in this area. In general, this review first introduces the basics of the theory and mechanism of acoustofluidic separation, then highlights the recent progress of the technology in biological applications, and finally discusses the challenges and perspectives of this field.

![](images/9b1abd6207c2c6a53c6517d2ff03385d01e52401a185bc0459c49912a973d3e4.jpg)  
Fig. 1 Different types of acoustic waves. a Schematic diagram of a surface acoustic wave generator; $d$ represents the width of the finger bar, $d ^ { \prime }$ represents the width between the fingers, M represents the length of the periodic section and W represents the acoustic aperture; b schematic diagram of bulk acoustic waves; c schematic diagram of traveling surface acoustic waves; d schematic diagram of standing surface acoustic waves.

# Theories of acoustofluidic separation

In this section, we will introduce the type of acoustic waves used, the principle of acoustic excitation, and several parameters that play important roles in determining the migration of the sorting targets, including Rayleigh angle, Stokes force, and acoustic radiation force (ARF).

# Acoustic waves

Acoustic waves are mechanical waves generated by the high-frequency vibration of piezoelectric materials (e.g., lithium niobate, lithium tantalite, quartz) when alternating current (AC) electrical signals act on them24. Depending on whether the entire body or just the surface of the material vibrates, acoustic waves can be divided into bulk acoustic waves (BAWs) and surface acoustic waves (SAWs). Additionally, acoustic waves are also distinguished as traveling waves or standing waves in the field of acoustics. Traveling waves are unidirectional waves with regular propagation, whereas standing waves are composite waves that transmit bilaterally.

BAWs are standing waves that propagate in the microchannel, which defines the resonance chamber or cavity (Fig. 1b)20. The acoustic waves travel into the microchannel through the solid–liquid interface after the piezoelectric material is activated and resonates within the channel when the channel width is an integer multiple of half-wavelength. The reflection of acoustic waves from the channel wall results in the emergence of BAWs. Because the formation of BAWs depends on reflection from the channel wall, soft polymer materials, such as polydimethylsiloxane (PDMS), are not suitable for channel materials, whereas materials with excellent acoustic properties, such as silicon and glass, are suitable for channel fabrication. The acoustic impedance of the substrate and the quality factor of the resonator are important for BAW propagation25. Both the inhomogeneity of the acoustic impedance of the piezoelectric substrate and the low quality factor of the resonator can cause significant attenuation of BAWs.

SAWs are elastic waves that travel along the surface of piezoelectric materials. SAWs were discovered in 1885 by the British physicist Lord Rayleigh26. They can be further divided into Lamb waves, Love waves, surface transverse waves, horizontal shear waves, leaky surface acoustic waves, Rayleigh waves, and electroacoustic waves according to the difference in acoustic vibration modes and boundary conditions. The typical SAW generator (Fig. 1a) is composed of a piezoelectric material substrate and metal interdigital transducers (IDTs) depositing on it27. Due to the inverse piezoelectric effect, the surface of the piezoelectric substrate undergoes subtle mechanical deformation when a sinusoidal AC signal is applied to the IDTs. As a result, the mechanical SAW is generated and propagates along the solid-air surface in the direction of deformation28. The wavelength of SAWs is dependent on the width and spacing between IDT fingers. In a uniform IDT where the width $d$ is equal to the spacing $d '$ , as shown in Fig. 1a, the wavelength can be calculated by $\lambda = 4 d$ . The acoustic frequency is calculated using the following equation:

$$
f = \nu / \lambda
$$

where $\nu$ is the speed of sound in the piezoelectric substrate.

SAWs can be further categorized into traveling surface acoustic waves (TSAWs) and standing surface acoustic waves (SSAWs). TSAWs are generated by IDTs on one side (Figs. 1c, 2a). SSAWs are excited by two opposing IDTs, which create a pattern of minimum and maximum pressure regions called pressure nodes and pressure antinodes, respectively, within the channel through the interaction of acoustic waves and fluid (Figs. 1d, 2b).

# Rayleigh angle

The amplitude of SAWs decays exponentially as they transmit through the channel wall. The remaining acoustic waves continue to propagate along the substrate until the acoustic streaming coupling phenomenon occurs. As a result, “leakage surface acoustic waves” form in the microchannel27. Due to the difference in the viscosity between the fluid and substrate, the propagation speeds of SAWs in the two media are different. The acoustic waves refract at the fluid-solid interface and enter the fluid field with a refraction angle, which is defined as the Rayleigh angle29:

$$
\theta _ { R } = \arcsin ( C _ { 1 } / C s )
$$

where $C _ { I }$ and $C _ { s }$ are the acoustic wave velocities in the fluid and the piezoelectric substrate, respectively. The acoustic speed of the same material with different tangential directions varies according to the anisotropy of the piezoelectric materials. Therefore, the Rayleigh angle is related to the tangential direction of the piezoelectric substrate. Due to the Rayleigh angle, there is a unique phenomenon called the “anechoic corner effect”; that is, the extremely weak ARF at the upper corner of the microchannel can barely affect the particles there (Fig. 2c).

![](images/2e1e11af4bfc24200c902ce4926fc6a278f140f8e1d09ea2e13dc61ca5b8a638.jpg)  
Fig. 2 Schematic diagrams of different types of surface acoustic waves. a Acoustic streaming effect of traveling surface acoustic waves; b acoustic streaming effect of standing surface acoustic waves; c schematic diagram of the “anechoic corner effect”. The yellow area represents an anechoic domain where the streaming effects and acoustic radiation force are weak, so particles and cells are barely affected.

# Stokes force

Acoustic streaming is a stable flow driven by the absorption of acoustic oscillations as acoustic waves with high frequency and amplitude act on the fluid. The generation of acoustic streaming is a result of the viscous attenuation feature of the fluid30. The particles and cells in acoustic streaming are subjected to the resistance force of the fluid, which is called the Stokes force. The Stokes force $( F _ { d } )$ can be calculated using the following formula:

$$
F _ { d } = 6 \pi u R _ { p } \nu
$$

where $u , ~ \nu ,$ and $R _ { p }$ denote the fluid viscosity, relative velocity between fluid and particles, and particle radius, respectively.

# Acoustic radiation force

In principle, the acoustic pressure gradient emerges due to nonlinear sound propagation in the fluid medium, which generates the ARF acting on the particles. There are two types of ARFs: the primary acoustic radiation force (PRF) and the secondary acoustic radiation force (SRF). In TSAWs, the trajectories of particles are determined by the interplay between the acoustic streaminginduced drag force and the ARF. The dominant force is determined by a dimensionless coefficient $( K _ { t r } )$ that was introduced by Skowronek et al.31:

$$
K _ { t r } = 2 \pi R _ { p } / \lambda
$$

where $R _ { p }$ is the radius of the particle and $\lambda$ is the acoustic wavelength. When $K _ { t r } < 1$ , the acoustic streaming-induced drag force is dominant, and the particle moves in the acoustic streaming vortex. When $K _ { t r } > 1$ , the particle is mainly driven by the ARF and moves away from the $\mathrm { I D T } ^ { 3 2 }$ . King derived the formula of a PRF acting on the particles in a TSAW as follows33:

$$
\begin{array} { l } { { F _ { \mathrm { P R F } } = 2 \pi \rho _ { l } \displaystyle { \left| { \cal A } \right| ^ { 2 } \left( k R _ { p } \right) ^ { 6 } \frac { 9 + 2 \left( 1 - \lambda _ { p } \right) ^ { 2 } } { 9 \left( 2 + \lambda _ { p } \right) ^ { 2 } } } } } \\ { { \lambda _ { p } = \displaystyle { \frac { \rho _ { l } } { \rho _ { p } } } } } \end{array}
$$

where $A$ represents the complex amplitude of velocity potential; $k$ represents the wavenumber of acoustic radiation; $R _ { p }$ represents particle radius; and $\rho _ { l }$ and $\rho _ { p }$ represent the density of the surrounding fluid and the particle, respectively.

In the SSAW field, PRF can be further divided into two components: the axial component $( F _ { a } )$ and the transverse component $\left( \boldsymbol { F } _ { t } \right) , \ F _ { a }$ is calculated using the equation below34:

$$
\begin{array} { l } { { F _ { a } = - \displaystyle \left( \frac { \pi p _ { 0 } ^ { 2 } V _ { p } \beta _ { l } } { 2 \lambda } \right) \phi ( \beta , \rho ) \mathrm { s i n } ( 2 k x ) } } \\ { { \phi ( \beta , \rho ) = \displaystyle \frac { 5 \rho _ { p } - 2 \rho _ { l } } { 2 \rho _ { p } + \rho _ { l } } - \frac { \beta _ { p } } { \beta _ { l } } } } \end{array}
$$

where $\phi$ is the acoustic contrast factor; $P _ { O }$ is the acoustic pressure amplitude; $_ x$ is the axial distance of the particle from the pressure node; $V _ { p }$ and $\beta _ { p }$ represent the volume and compressibility of the particle, respectively; and $\beta _ { l }$ denotes the compressibility of the fluid.

$F _ { a }$ can direct particles toward either pressure nodes or antinodes, which is determined by the acoustic contrast factor $( \phi )$ . When $\phi > 0$ , particles move toward the pressure nodes; when $\phi < 0$ , particles move toward the pressure antinodes. When particles are pushed toward the nodal plane, the axial force is negligible, and the transverse pressure force becomes dominant. The equation of

$F _ { t }$ is derived by the Whitworth function as follows35:

$$
F _ { t } = 3 d _ { p } ^ { 3 } \frac { \rho _ { p - } \rho _ { l } } { 2 \rho _ { p } + \rho _ { l } } \nabla \langle E _ { \mathrm { a c } } \rangle
$$

where $\nabla < E _ { \mathrm { a c } } >$ represents the acoustic energy gradient, $< >$ represents the time average, and $d _ { p }$ represents the distance between particles. The transverse pressure force pushes particles closer to each other. As the distance between the particles decreases, the force becomes weaker until the particles aggregate together at the pressure node or antinode.

Although the migration of a single particle is mainly affected by the PRF, the SRF becomes important when multiple cells or particles aggregate. As demonstrated by Saeidi et al., when the distance between particles is small, the trajectory of the particles is strongly affected by the $\mathrm { S R F } ^ { 3 6 }$ . Silva and Bruus demonstrated that two particles in close proximity could either attract or repel each other in a direction that is perpendicular to the wave propagation within the Rayleigh limit when the acoustic wavelength is much greater than the particle size37. Hashmi et al. verified that whether the SRF acts as an attractive or repulsive force depends on the ratio of fluid density to particle density38. More recently, Mohapatra et al. showed that the interparticle ARF is proportional to the diameter of particles39. Wiser et al. derived the SRF equation of two particles with identical acoustic properties and radii in the Rayleigh limit40:

$$
F _ { \mathrm { S R F } } ( x ) = 4 r ^ { 6 } \left[ \frac { \Bigl ( \rho _ { p } - \rho _ { f } \Bigr ) ^ { 2 } ( 3 c o s ^ { 2 } \theta - 1 ) } { 6 \rho _ { f } d ^ { 4 } } \nu ^ { 2 } ( x ) - \frac { \omega ^ { 2 } \rho \bigl ( k _ { p } - k _ { f } \bigr ) ^ { 2 } } { 9 d ^ { 2 } } p ^ { 2 } ( x ) \right]
$$

where $\nu ( x )$ and $p ( x )$ represent the particle velocity and acoustic pressure, respectively, $\theta$ represents the angle between the centerline that connects two particles and the direction of acoustic wave propagation, $\omega$ is the angular frequency of the sound wave, and $d$ is the distance between the centers of the two particles.

In the case of a particle close to a bubble, the SRF can be calculated using the following equation41

$$
F _ { \mathrm { S R F } } = 4 \pi \rho _ { l } \frac { \rho _ { l } - \rho _ { p } } { \rho _ { l } + 2 \rho _ { p } } \frac { R _ { b } ^ { 4 } R _ { P } ^ { 3 } } { d ^ { 5 } } \omega ^ { 2 } \xi ^ { 2 }
$$

where $\rho _ { l }$ and $\rho _ { p }$ are the densities of fluid and particles, respectively; $d$ is the distance between the particle and bubble; $\omega$ is the angular frequency; $\xi$ is the amplitude of bubble oscillation; and $R _ { b }$ and $R _ { p }$ are the radius of the bubble and particle, respectively. The direction of the force depends on the values of $\rho _ { l }$ and $\rho _ { p } ,$ which determine whether the force is attractive or repulsive.

Table 1 Overview of different acoustofluidic separation devices.   

<html><body><table><tr><td>Type of acoustic waves</td><td>Typical exciter</td><td>Features of devices</td><td>Ref.</td></tr><tr><td>Bulk acoustic waves</td><td>Piezoelectric material</td><td>Easy to fabricate, but diffcult to manipulate pressure nodes 71.82 and antinodes</td><td></td></tr><tr><td>Traveling surface acoustic waves</td><td>One IDT</td><td>Flexible to manipulate and generate acoustic streaming</td><td>43.73</td></tr><tr><td>Standing surface acoustic wavesA pair of opposing IDTs</td><td></td><td>Convenient control of pressure nodes and anti-nodes</td><td>42.69,72</td></tr><tr><td>Tilted-angle traveling surface acoustic waves</td><td></td><td>One IDT with tilted-angle along the channelIncreased migration distance of target particles</td><td>60</td></tr><tr><td>Tilted-angle standing surface acoustic waves</td><td>the channel</td><td>A pair of opposing IDTs with tilted-angle along Long distance migration and stable separation for multiple 63,74 particles</td><td></td></tr></table></body></html>

# Mechanisms of acoustofluidic separation

In addition to understanding the principles of acoustofluidic separation, researchers have also conducted experimental studies aimed at effectively separating particles or cells from mixtures. Various separation methods have been explored using different acoustofluidic devices. The basic mechanisms of these methods will be summarized in this section. Different types of acoustofluidic separation devices are listed in Table 1.

# Separation methods based on size

Because the ARF acting on particles is proportional to the particle size, it is natural to use acoustic waves to separate particles of different sizes. Many acoustofluidic devices42–45 have been developed based on this separation principle. However, other factors, such as the structure and position of IDTs, can affect the outcomes in sizebased separation.

The most common IDT structure is rectangular. Although widely used, this type of IDT is not suitable for applications that require high acoustic energy in a narrow domain. Therefore, some special IDT structures have been developed to meet the needs of different applications. One type of specially designed IDT is the focused interdigitated transducer (FIDT), which has arcuate IDT fingers, and one side of the FIDT is narrower than the other side46. A higher energy intensity and narrower beam width can be generated at the narrow side47,48. As a result, the force exerted on the particles and cells is stronger, and a higher sorting resolution can be realized. By using FIDTs, Collins et al. were able to generate an effective sorting region with a width of ${ \sim } 2 5 \mu \mathrm { m } ^ { 4 9 }$ . The submillisecond pulses generated at kHz rates allowed for the high-speed sorting of $2 \mu \mathrm { m }$ particles from $1 \mu \mathrm { m }$ particles (Fig. 3a). Later, the same group used FIDT to generate fluid vortices that extend over the entire channel width50. This design maximized the effect of acoustic streaming and was able to selectively capture $2 \mu \mathrm { m }$ particles from a mixed suspension with $1 \mu \mathrm { m }$ particles and capture human breast cancer cells from red blood cells (RBCs). Another type of specially designed IDT is the slanted interdigitated transducer (SIDT). In an SIDT, the distance between fingers on one side is narrower than that on the other side, resulting in a tapered shape of the entire structure. The change in finger spacing makes the optimum actuated frequency tunable over a wide range, which has the advantages of generating different amplitude profiles to facilitate the size-selective separation of particles or cells51,52. Destgeer et al. demonstrated the separation of polystyrene (PS) particles of three different sizes using a pair of SIDTs (Fig. 3b)53. By carefully designing the tapered shape, the left and right SIDTs could generate a range of different frequencies in different positions along the flow direction, forming the basis to manipulate different particles. In one set of experiments, the authors demonstrated that $5 \mu \mathrm { m }$ particles deflected to the top-left anechoic corner upstream when $f _ { L } < f _ { R } , ~ 4 . 2 \mu \mathrm { m }$ particles deflected to the right side of the channel downstream when $f _ { L } > f _ { R } , 5 \mu \mathrm { m }$ particles were unaffected in the anechoic corner, and the smallest $3 \mu \mathrm { m }$ particles remained in the middle part of the channel due to the lower ARF exerted on them. Moreover, this device was shown to be useful for medium exchange application by alternatively moving the particles from the left to the right medium. Recently, $\mathrm { J i }$ et al. developed an acoustofluidic device that integrates a spiral channel for sheathless focusing of the selected particles, an offset micropillar array for concentrating the particles on one side of the channel, and an SIDT for deflecting the target particles54. The experiment showed that this device achieved the separation of $2 0 \mu \mathrm { m }$ particles with $9 2 \%$ purity and $1 0 0 \%$ efficiency.

In addition to the IDT structure, the position of the IDT can be adjusted to generate a special effect for particle separation. In classic SAW devices, IDTs are usually placed at a certain distance beside the microchannel. The separation is based on the horizontal displacement of particles. In some studies, IDTs are placed underneath the microchannel to allow vertical separation of particles and cells55–57. Using this strategy, Ahmed et al. developed a TSAW device to continuously separate particles of different sizes (Fig. 3c)58. This device took advantage of the vertical ARF component to push the selected particles upward in the microchannel. The horizontal ARF component was used to slow down the separated particles in the lateral direction, which also gave the particles more time for vertical migration and improves separation efficiency. They demonstrated the continuous separation of $4 . 8 \mu \mathrm { m }$ PS particles from 2.0 and $3 . 2 \mu \mathrm { m }$ ones at high efficiency $( > 9 9 \%$ purity and recovery). In typical acoustofluidic sorting devices, IDTs are usually placed parallel to the microchannel. This layout results in a maximum distance of one-quarter of the wavelength that the particles can deflect in SSAW devices59. These limitations can be addressed by putting the IDTs at an angle to the channel. This type of device includes tilted-angle traveling surface acoustic wave (taTSAW) devices and tilted-angle standing surface acoustic wave (taSSAW) devices. For taTSAWs, the IDT is placed on one side of the channel at a tilted angle to generate a traveling SAW that can be used to deflect the particles in the channel. Ahmed et al.

![](images/d0a90ee18204266cec6bf18eb977fa20340d7229d2865dcd6905573216c2bec8.jpg)  
Fig. 3 Size-based separation using different interdigital transducer designs and positions. a Focused interdigital transducers were placed beside the microchannel to generate high-energy-density traveling surface acoustic waves for particle separation. Reproduced from ref. 49 with permission from the Royal Society of Chemistry. b A pair of slanted interdigitated transducers placed on the two sides of the microchannel was activated by different frequency signals for particle separation. Reproduced from ref. 53 with permission from the American Chemistry Society. c An interdigital transducer placed under the microchannel was used to separate polystyrene particles of different sizes via vertical migration. Reproduced from ref. 58 with permission from Wiley Online Library. d A pair of tilted-angle interdigital transducers was used to enhance the cell deflection in the microchannel. Reproduced from ref. 64 with permission from the Institute of Electrical and Electronics Engineers.

developed a taTSAW device for sheathless focusing and separation of microparticles in a continuous flo w60. A pair of IDTs was set below the channel at angles of $2 1 0 ^ { \circ }$ and $1 5 0 ^ { \circ }$ relative to the principal axis of the substrate wafer. The first IDT used a frequency of $1 9 4 \mathrm { M H z }$ to push all particles to one side of the microchannel, while the second IDT separated $4 . 8 \mu \mathrm { m }$ fluorescent PS particles from $3 . 2 \mu \mathrm { m }$ particles using 136 MHz frequency with a purity $>$ $9 9 \%$ . For the taSSAW, a pair of tilted-angle IDTs is patterned beside the microchannel to form a standing wave, which makes the pressure nodes or antinodes also not parallel to the channel61,62. Ding et al. developed a taSSAW device (with a $3 0 ^ { \circ }$ tilted angle) to separate PS beads with different diameters (2 and $1 0 \mu \mathrm { m } )$ ) and achieved ${ \sim } 9 9 \%$ separation efficiency63. Multiple nodal lines crossed the channel because of the tilted angle of the IDT. Target particles deflected to one side of the channel by migrating toward the nodal lines, whereas nontarget particles were not affected because the ARF applied to them was weak. Recently, Wu et al. introduced a filled tilted-angle (FTA) SAW device, which effectively separated HeLa cancer cells from peripheral blood mononuclear cells (PBMCs)64.

![](images/46853bc4c139ec359a1e153a989fa2bc25001b0789ea915af908fa6bb8c9a3a8.jpg)  
Fig. 4 Acoustofluidic separation based on nonsize properties. a Separation of HeLa and MDA-MB-231 cells from peripheral blood mononuclear cells based on the acoustic impedance difference. Reproduced from ref. 71 with permission from the Royal Society of Chemistry. b Separation of polystyrene and polymethyl methacrylate particles with the same diameters based on the differences in particle density and propagation speed of sound using a traveling surface acoustic wave device. Reproduced from ref. 73 with permission from the American Chemistry Society.

By filling the space adjacent to the microchannel with IDTs (Fig. 3d), the device exhibited a higher separation efficiency $( 3 2 \% )$ than the conventional system. At an input power of $4 . 5 \mathrm { W }$ , the separation efficiencies for HeLa cells and PBMCs were approximately 90 and $2 5 \%$ , respectively. In most of the current SAW devices, the microchannel layers are irreversibly bonded to the IDT layer. While the devices in many biomedical applications should be single use, the cost of each test is high because of the high fabrication cost of IDTs. Detachable SAW devices have been developed to reduce this cost by reusing the IDT components. This requires the transmission of SAW energy from the IDT substrate to the microchannel superstrate. Different coupling agents and strategies have been explored65–67. Ma et al. designed a disposable TSAW-based separation device and successfully separated PS particles with sizes of 10 and $1 5 \mu \mathrm { m } ^ { \dot { 6 } 8 }$ . The microstructured pillar was used to bond the substrate and PDMS microchannel, which acts as the coupling agent and allows the detachment of the two components after use. Moreover, the unique connection mode effectively eliminated the “anechoic corner effect”, subjecting the entire channel to SAW, which also maximized the acoustic force for separation.

# Separation methods based on nonsize properties

Although size-based separation methods have shown great success in separating cells or particles of different sizes, they cannot separate particles of the same size or particles with small size differences. In such cases, separation methods based on other physical properties have been explored69. The acoustic impedance $( Z )$ , which is related to the density and speed of sound through the material, has been selected as a candidate property for separating particles or cells. It has been demonstrated that when certain conditions are met, the migration direction of the particles can be determined by the impedance difference of the particle and the medium70. If the acoustic impedance of particles is higher than that of the medium $( Z _ { p } > Z _ { m } )$ , the particles migrate toward the pressure node. Similarly, the particles migrate toward the pressure antinode if the impedance is lower than that of the medium $( Z _ { p } < Z _ { m } )$ . If there is no impedance difference between the particle and the medium, the particles encounter only acoustic streaming. Karthick et al. successfully developed such an acoustic impedance-based separation device to isolate circulating tumor cells (CTCs) from PBMCs in $1 \mathrm { { h } }$ with $> 8 6 \%$ recovery and $\mathrm { > } 5 0$ -fold enrichment (Fig. 4a)71. By adjusting the impedances of the middle medium and sheath liquid compared to those of different cells, both the high-impedance CTCs (i.e., HeLa) and the low-impedance CTCs (i.e., MDA-MB-231) could be separated from PBMCs. One limitation of this acoustic impedance-based method is that it requires adjusting the medium’s impedance levels, which may be harmful for live cells. Thus, separation methods that rely solely on particle properties have been investigated. Jo et al. developed a sheathless device to separate particles of the same size but different densities72. In this study, two pairs of IDTs were used to form SSAWs in the channel but configured with different pressure node positions. All particles would aggregate in the center pressure node when particles passed the first IDT pair due to the relatively long-term exposure to ARF. When particles passed the second IDT pair area where the pressure nodes were configured to the sidewalls, the high-density particles migrated toward the sidewalls further than the lowdensity particles due to the relatively short-time exposure to ARF, resulting in particle separation. Ma et al. proposed a method to separate particles based on the difference in density and speed of sound through the particles using a TSAW device (Fig. 4b)73. They theoretically and experimentally demonstrated that PS and polymethyl methacrylate (PMMA) particles with the same diameters exhibited nonlinear and distinct acoustophoretic responses as a function of their density, the speed of sound through them, and the applied TSAW frequency. Recently, Liu et al. demonstrated the taSSAW-based separation of SiO2, PMMA and PS particles, which have the same volume and different densities74. The team optimized the working parameters, such as the peak-topeak voltage of the IDTs, the maximum flow velocity, and the fork-optimal flow ratio coefficients, using simulations to achieve precise sorting. The experimental results showed that the separation rates and purities were all above $9 0 \%$ for the three particles.

# Biological applications of acoustofluidic separation technologies

Acoustofluidic separation has a wide range of biological applications, including micron-sized cells and submicron bioparticles. Table 2 lists some representative applications.

# Separation of cells Separation of cancer cells

Cancer remains a major disease burden worldwide. Indepth studies of cancer cells not only contribute to the understanding of the mechanisms of cancer development and progression but also facilitate the development of medical interventions. Precise and efficient isolation of cancer cells from normal cells is an important prerequisite for cancer research. Both SSAW- and TSAW-based devices have been developed for the isolation of cancer cells69,75. Li et al. developed a taSSAW-based chip for the isolation of CTCs from white blood cells $( \mathrm { W B C s } ) ^ { 7 6 }$ . To significantly improve the separation throughput, which is critical for the practical application of CTCs, the authors designed both numerical and experimental models to systematically optimize multiple design parameters, including tilt angle, flow rate, IDT length, and input power. The optimized device was shown to be capable of isolating rare CTCs from WBCs at a flow rate of $1 . 2 \mathrm { m l / h }$ The recovery rate was validated to be ${ > } 8 7 \%$ for MCF-7 and HeLa cells and ${ > } 8 3 \%$ for four other cancer cell lines. Lu et al. used acoustic microstreaming traps to separate MCF-7 breast cancer cells (Fig. 5a)77. An array of micropillars were patterned inside the microchannel. When the SAWs were generated, microstreaming formed around the micropillars. Cancer cells were captured by the nearest pillar trap due to their large size, whereas other cells flowed out with the fluid. After the acoustic vibration stopped, the captured cancer cells could be released. Using this device, it is possible to achieve a capture efficiency of $9 5 \%$ for MCF-7 in spiked saline buffer and diluted serum and $6 6 \%$ for the whole blood samples. Furthermore, the platform is compatible with affinity-based sorting methods, thus showing great potential to further improve the isolation efficiency and specificity for clinical detection and diagnosis.

Cancer cell isolation has also been investigated in BAWbased devices78,79. Faridi et al. developed a microfluidicbased microBubble-Activated Acoustic Cell Sorting (BAACS) system to sort HCT 116 colon cells; the system relies on the specific binding of cancer cells to the surfacefunctionalized microbubbles and the different acoustic contrast coefficients of microbubbles and cells in the acoustic field (Fig. 5b)80. Due to the strong negative acoustic contrast coefficient of the microbubbles, the target cells bound to the microbubble moved to the pressure antinodes, whereas the unbound cells migrated to the pressure nodes due to their positive acoustic contrast coefficient. More than $7 5 \%$ sorting efficiency was achieved using this device. Iranmanesh et al. developed an acoustofluidic device that combines the separation and trapping of A549 lung cancer cells from RBCs in a single chip81. This device consisted of a prealignment zone, a size-based separation zone, and a trapping zone, which were realized by placing three ultrasound transducers with different frequencies $( 4 . 4 \mathrm { M H z } ,$ $1 . 3 9 \mathrm { M H z }$ , and $2 . 7 8 \ : \mathrm { M H z }$ ) consecutively along the channel. Cancer cells were enriched 130-fold with $1 0 0 \%$ purity, $9 2 \%$ separation efficiency, and $9 3 \%$ trapping efficiency in a 15-minute continuous process. Bai et al. reported acoustic microstreaming-induced isolation of 4T1 cells from whole blood samples of postoperative mice82. With the piezoelectric transducer and PDMS channel bonded on the glass slide, acoustic waves were transmitted into the channel, which consisted of an array of microcavities. The team optimized the geometry of the microcavities so that the velocity of the acoustic energy-induced fluid in the microcavities was higher than that in the main channel. As a result, when the acoustic waves were generated, larger CTCs were captured in the cavities and separated from other substances in the blood. This device demonstrated a high capture and separation efficiency $( > 9 6 \% )$ .

# Separation of bacteria

Bacterial infection can sometimes cause severe symptoms. Rapid and effective isolation of bacteria from complex body fluids can help identify the type of bacteria and confirm the diagnosis. Although bacteria are usually irregular in shape and smaller than eukaryotic cells, they can still be affected by acoustic waves and separated accordingly. Ai et al. isolated Escherichia coli (E. coli) from

<html><body><table><tr><td></td><td colspan="3">Table 2 Representative biological applications of acoustofluidic separation.</td></tr><tr><td>Separated bioparticles</td><td>Acoustic types Results</td><td></td><td>Advantages</td></tr><tr><td>CTCs</td><td>taSSAW</td><td>1.2 ml/h flow rate; &gt;87% recovery rate of MCF-7 and HeLa cells</td><td> High throughput</td></tr><tr><td></td><td>BAW</td><td>Isolation of 4T1 cancer cels from whole blood samples with 96% efficiency; completely simulate the clinical treatment procedure</td><td>Cost-eficient; easy operation; high efficiency</td></tr><tr><td></td><td>BAW</td><td>IsolationofA549lungcancercelswith00%purity,92%separationficiencyinHighpurity;highefiency;fastprocessing 15 minutes</td><td></td></tr><tr><td>Bacteria</td><td>taSSAW</td><td>The separation of E. coli from RBCs with more than 96% purity</td><td> High purity; easy operation</td></tr><tr><td></td><td>SSAW</td><td>E.coliwasseparated from human RBCswith 92.7% purityand &gt;25mm/sflow rateHigh throughput and rapid separation</td><td></td></tr><tr><td></td><td>BAW</td><td>~97% isolation efficiency of S.aureus</td><td>High resolution; high efficiency</td></tr><tr><td>Blood cells</td><td>BAW</td><td>RBCsandWBCsremovalandplateletrecoveryof80% using10mL/min flowrateVerticalacousticforce wasusedforseparation</td><td></td></tr><tr><td></td><td>BAW</td><td>31.8%plasmayieldand99.9%plasmapurity.8μL/min;realiationof~17pg/Microstreamingcanbeusedasamicropumpforhesample μL of target HIV p24 antibodies from whole blood sample</td><td>integration with downstream components</td></tr><tr><td></td><td>SSAW</td><td>99% RBCs and WBCs removal ratio; nearly 98% platelet purity</td><td> High purity; whole blood separation</td></tr><tr><td>Viruses</td><td>BAW</td><td>TheyieldofMSwas&gt;0%and8%ofsaccaromescerevsiaewereremovedGoodseparatioperformance;earlyprof-of-conceptdevc</td><td></td></tr><tr><td></td><td>BAW</td><td>The separation purities of Dengue viruses and human lymphocytes are 98% and Novel structure design</td><td>on BAWs</td></tr><tr><td></td><td>TSAW</td><td>70%, respectively The JEV virus was separated from the complex biological samples</td><td>Easy to operate; mild to target virus</td></tr><tr><td>Proteins</td><td>BAW</td><td>The separation efficiency of blood cells &gt;9o%; the releasing efficiency of</td><td>Bioaffinity microbead-assisted methods</td></tr><tr><td></td><td>TSAW</td><td>streptavidin &gt;75% The human thrombin,IgE,and mCardinal2 protein were successfully separated</td><td>Triseparation of proteins simultaneously</td></tr><tr><td>Exosomes</td><td>SSAW</td><td>&gt;90% isolation yield of exosomes</td><td>One-step direct isolation of exosomes</td></tr><tr><td></td><td>taSSAW</td><td>Isolation of exosomes from whole blood with 99.999% blood cels removed</td><td>Excelent sorting efficiency of exosomes; whole blood separ</td></tr></table></body></html>

![](images/f0fd4be40d880b041c6808349f5cecdf9f7ea94968f42352f2ccfe12c97561e4.jpg)  
Fig. 5 Acoustofluidic separation of cells. a An acoustic microfluidic trap array to separate cancer cells. Reproduced from ref. 77 with permission from Wiley Online Library. b A microBubble-Activated Acoustic Cell Sorting (BAACS) method to separate HCT 116 colon cancer cells. Reproduced from ref. 80 with permission from SpringerLink. c Bacterial separation from red blood cells based on different acoustophoretic responses using a lowcost plastic bulk acoustic wave-based device. Reproduced from ref. 87 with permission from the Royal Society of Chemistry. d High-throughput separation of red blood cells/white blood cells and platelets from whole blood using a vertical acoustic force. Reproduced from ref. 91 with permission from the Royal Society of Chemistry.

PBMCs using a standard SSAW device83. In this device, PBMCs were shifted to the pressure nodes on the sidewalls due to their larger size, whereas $E _ { \ast }$ . coli were concentrated in the center of microchannel by sheath flow with a purity of $9 5 . 6 5 \%$ . Li et al. used a taSSAW device to separate $E _ { \ast }$ coli from RBCs with more than $9 6 \%$ purity84. When using whole blood samples, their device was able to remove RBCs and WBCs but failed to separate $E .$ coli from platelets. Nevertheless, the authors demonstrated that this enrichment could decrease the nonspecific signals during the downstream electrochemical detection of $E _ { \ast }$ . coli in whole blood samples. Ning et al. designed a serpentine acoustofluidic device for the separation of $E _ { * }$ coli bacteria from $\mathrm { W B C s } ^ { 8 5 }$ . Unlike the previously mentioned serpentine channel for particle concentration75,86, this device placed samples in an acoustic field to extend the action length; thus, a higher flow rate could be used. For successful and accurate separation, the width and spacing of the channel were integer multiples of half wavelengths. Larger WBCs migrated to the pressure nodes, whereas the smaller bacteria remained in the middle of the channel due to the weaker ARF, causing them to flow out from different outlets. The result showed $9 2 . 7 \%$ separation purity and a $2 5 \mathrm { m m s } ^ { - 1 }$ flow rate, which is higher than similar devices reported previously.

In addition to SAW-based devices, BAW-based devices have also been used for bacterial isolation. Dow et al. developed a low-cost plastic BAW device to isolate three pathogenic bacteria, including Pseudomonas aeruginosa, Staphylococcus aureus (S. aureus), and $E _ { \ast }$ . coli, from RBCs or whole blood at clinically relevant concentrations87. The mixture sample was input into the chip from both side inlets. The blood cells were shifted to the center outlet due to the larger acoustophoretic response, while the bacteria were less affected by the ARF and collected from the side outlets (Fig. 5c). By incorporating a bacteriophage-based luminescence assay after acoustophoretic separation, a 33-fold improvement in the detection limit was demonstrated compared with the unpurified sample. Assche et al. presented an interesting method for the isolation of S. aureus from blood lysate called gradient acoustic focusing88. Instead of using the whole blood sample directly, the blood sample was preprocessed with lysis agent. The large cells and platelets were lysed without damaging the viability of the target bacteria. The theoretical and experimental studies confirmed that when the acoustic impedance of the central liquid (Z1) is larger than that of the particle suspension (Z0), the BAW-driven ARF suppressed acoustic streaming, and forced particles migrate to the central position of the channel from the sidewalls. As a result, the isolation of S. aureus achieved a high efficiency of $9 7 . 0 \pm 0 . 9 \%$ Moreover, this technique could separate submicron particles and cells, showing the ability for applications of other substances.

# Separation of blood cells

Blood serves as a circulating carrier that provides the body with various nutrients and oxygen and removes waste. The numerous cells in the blood characterize the physiological state of the body. Changes in the number and state of blood cells often lead to diseases. The isolation of specific cells from blood can help to diagnose and treat health problems. Petersson et al. demonstrated the separation of RBCs and platelets using a BAW-based device59. Cells were added through the side inlets. Cesium chloride solution was added through the middle inlet to manipulate the relative density between the cells and fluid to enhance the separation efficiency. However, whether the added solution has an irreversible negative impact on the cells needs to be further studied. Cells were separated and flowed out of different outlets based on their sizes and densities. The separation of RBCs, platelets, and leukocytes in the buffy coat was also investigated using this device. While the efficiency of separating multiple cells simultaneously was not high, this early BAW-based microfluidic device was instrumental in promoting the use of similar systems in blood cell isolation. Liu et al. demonstrated that bubble-driven acoustic microstreaming can be used to separate cells and plasma in whole blood samples with a plasma purity of $9 9 . 9 \% ^ { 8 9 }$ . Rectangular lateral cavities were positioned at a $1 5 ^ { \circ } { }$ angle from the channel to trap air bubbles. An acoustic microstreaming vortex was generated by the trapped bubbles with the vibration of the piezoelectric substrate. The sizeand density-dependent trapping principle contained the larger blood cells in the vortex, allowing the blood plasma to flow downstream. Meanwhile, the fluid vortex acted as a micropump, which facilitated the continuous flow of fluid without integrating other pump equipment. Furthermore, the device utilized a similar bubble-driven microstreaming effect to enhance the mixing of the antigen-conjugated PS beads and $\mathrm { H I V - p } 2 4$ antibodies in plasma and trap the complexes for fluorescent detection to assess the concentration of HIV-p24 antibodies. This multifunctional device shows its ability to rapidly separate and detect biomarkers in blood samples.

With the development of acoustofluidic theory, SAWs have also been applied for the separation of cells in blood. Nam et al. separated platelets from undiluted whole blood using a classic SSAW device90. Sheath flows were input from side inlets to hydrodynamically focus the blood sample $( 0 . 2 5 \mu \mathrm { l / m i n } )$ in the middle of the channel. Actuated by SSAW, large cells (RBCs and WBCs) migrated to sidewalls where pressure nodes formed, and platelets were extracted from the middle outlet due to their smaller diameter. The $9 9 \%$ RBC and WBC removal ratio and nearly $9 8 \%$ platelet purity demonstrated the good performance of this method. Chen et al. also developed an acoustic microfluidic device for platelet separation from whole blood with higher throughput91. Instead of using lateral cell migration, the vertical acoustic force was harnessed for separation. RBCs/WBCs were subjected to a stronger vertical acoustic force and were pushed to the upper layer, while the platelets were kept in the bottom layer (Fig. 5d). They achieved RBC/WBC removal and platelet recovery of $8 0 \%$ using a $1 0 \mathrm { m L } / \mathrm { m i n }$ flow rate and slightly higher efficiency when using a $5 \mathrm { m L } / \mathrm { m i n }$ flow rate. The balance between high throughput and sorting efficiency requires further investigation for this application.

# Separation of bionanoparticles Separation of viruses

Viruses are small particles of genetic material that are surrounded by a protein coat. The size of most viruses varies in diameter from 20 to $4 0 0 \mathrm { n m }$ . Viruses can infect host cells and cause various diseases, such as AIDS, hepatitis, and COVID-19. Currently, polymerase chain reaction (PCR) and enzyme-linked immunosorbent assays (ELISAs) are considered the gold standard for virus detection. Both methods are capable of detecting viruses accurately. However, a long detection time, a requirement for complicated equipment, and the need for professional operation remain the common deficiencies of these methods92. Therefore, new strategies are needed for isolating and detecting viruses rapidly and accurately. The application of acoustofluidic devices in virus isolation has been investigated. Since the size of the virus is too small to be affected by ARFs, viruses have been concentrated by removing the cells using ARF from the virus–cell mixture. Jung et al. demonstrated a microfluidic BAW-based device that can isolate Saccharomyces cerevisiae (S. cerevisiae) and MS2 bacteriophage93. The sample mixture and deionized water were input into the two inlets of the H-filter device. A standing wave was formed, and the pressure node was located at the center of the channel. The ARF drove the larger S. cerevisiae cells toward the pressure node, and then cells flowed out to a different outlet other than the unaffected MS2 bacteriophage. The results showed that yields of MS2 were greater than $9 0 \%$ and $8 0 \%$ of the S. cerevisiae were removed. Similarly, with the application of BAWs, Fong et al. designed a unique channel structure for the separation of cell-free Dengue viruses $( 5 0 \mathrm { n m } )$ from human lymphocytes $( 5 { - } 8 \mu \mathrm { m } ) ^ { 9 4 }$ . A second fluid channel was fabricated parallel to the main channel, which formed a thin silicon wall called a “transparent wall” to decouple the fluid and acoustic boundaries. As a result, asymmetric pressure nodes can be generated in the fluidic channel, which can push the cells further into the other half-channel and achieve better separation. The results showed that the separation purities of Dengue viruses and human lymphocytes were 98 and $7 0 \%$ , respectively. Recently, the specific separation of Japanese encephalitis virus (JEV) from complex biological samples was realized by capturing the virus first using antibody-functionalized microparticles and then enriching the particle-virus composites using a TSAW device (Fig. 6a)95.

![](images/f9a4419c80239baccc5349099e7bf8649e8d1b0f0f83c187db39633e66304a5d.jpg)  
Fig. 6 Acoustofluidic separation of bionanoparticles. a Separation of Japanese encephalitis virus from complex biological samples. Reproduced from ref. 95 with permission from Elsevier. b Triseparation of proteins from the mixture based on aptamer-coated microparticles and TSAW. Reproduced from ref. 99 with permission from the American Chemistry Society. c Exosome separation from plasma samples using a multistage acoustofluidic device. Reproduced from ref. 104 with permission from Nature.

# Separation of proteins

Proteins are a class of macromolecules that perform a diverse range of functions within organisms. The effective sorting and accumulation of proteins are central goals in protein biotechnology. Due to the small size of proteins, ARF is not sufficient to directly manipulate proteins in typical acoustofluidic setups. Instead of using a flow-based device, Neumann et al. applied SSAWs on supported lipid bilayers (SLBs) and demonstrated the redistribution of proteins on planar SLBs96. When SAWs were coupled with SLBs, the membrane density was modulated, resulting in lipid transport and accumulation. The proteins anchored to the SLB by binding approaches, such as biotin-avidin, hydrophobic, and electrostatic interactions, could also be patterned using the same setup. By tuning the two IDTs with slightly different frequencies, lipid and protein transport was realized due to the shifting of the SAW pattern. Furthermore, protein separation was observed when two different proteins with different properties, such as molecular weight, isoelectric point, and ability to crystallize, were deposited on the same SLB, which was attributed to their competition for the antinode position. For example, separation of streptavidin and avidin was demonstrated despite their similarity in size and nature but differences in their ability to crystallize. In addition to the direct acoustic separation of proteins on

SLBs, bioaffinity microbead-assisted methods have been adopted to separate proteins. For instance, Ahmad et al. successfully separated thrombin from mCardinal2 and human serum samples by capturing the proteins using aptamer-functionalized PS beads in a TSAW device97. Similarly, Li et al. developed a type of thermally responsive polypeptide fused to ligands that acts as a linking agent to selectively capture proteins into silicone microparticles for separating specific proteins from blood using a BAW device98. In particular, the separated proteins could be released from the microparticles for downstream analysis by cooling the solution below the solubility temperature of the polypeptides. Using streptavidin spiked in blood plasma as a model protein, the authors demonstrated that their method could achieve a separation efficiency exceeding $9 0 \%$ with a limit of detection of $0 . 7 5 \mathrm { n M }$ and a release efficiency greater than $7 5 \%$ . Afzal et al. proposed an SIDT-generated TSAW device to separate three different types of proteins simultaneously based on the selective capture of proteins using aptamercoated microparticles of different sizes (Fig. 6b)99. Thrombin and IgE proteins were captured by two types of PS microparticles coated with apt15 and aptD17.4, respectively, while mCardinal2 proteins were unbound. The mixture was injected into the microchannel, and the three proteins were separated by ARF based on the difference in size.

# Separation of exosomes

Exosomes are small extracellular vesicles secreted by cells that contain many constituents of the parent cells, including DNA, RNA, and protein. They are present in various body fluids and are important media of intercellular communication. Exosomes have been recognized to be particularly useful in disease diagnosis and therapeutic applications100. Accordingly, exosome separation technology from complex biofluids has attracted increasing research interest. Unlike traditional ultracentrifugation and filtration separation methods that usually require multiple operation steps, the acoustofluidics-based method allows separation in a continuous manner with less sample loss and a lower potential for structural damage, offering a promising approach for exosome separation. Due to the small size of exosomes $( 4 0 - 1 6 0 \mathrm { n m } )$ , a high ARF is required to separate them in acoustofluidic devices. Lee et al. developed an SSAW nanofilter to isolate exosomes $\left( < 2 0 0 \mathrm { n m } \right)$ from other larger extracellular microvesicles (MVs) in cell culture media and stored RBC products101. The cutoff size and the separation performance were optimized by adjusting parameters such as the channel design, acoustic transducer design, and flow rate. A ${ \tt > } 9 0 \%$ isolation yield of exosomes was achieved using the system. $\mathbb { W } \mathbf { u }$ et al. developed a method to isolate exosomes directly from whole blood using a multistage acoustofluidic device102. The device consisted of two pairs of tilted-angle IDTs to generate taSSAWs. The first microscale cell-removal module was used to isolate large blood components (e.g., RBCs, WBCs, and platelets), and the second exosome-isolation module could isolate exosomes from MV mixtures with a purity of $9 8 . 4 \%$ . A $9 9 . 9 9 9 \%$ blood cell removal rate was achieved when the two modules worked together. Later, the same group used a similar device to study the effect of liquid viscosity on exosome separation103. The results demonstrated that the movement of particles in high-viscosity fluid was lower than that in low-viscosity fluid. The device was applied to separate exosomes from saliva samples. Recently, Wang et al. applied this model to isolate exosomes from plasma samples collected from mice with well-characterized closed-head injuries (Fig. 6c)104. Subsequent analysis demonstrated increased exosome secretion following traumatic brain injury (TBI), which provides a potential approach for the rapid diagnosis of TBI.

# Conclusion and perspective

In this review, we summarized the theories and mechanisms of acoustofluidic separation technology. Most existing separation methods are based on differences in particle size. For particles of similar size, acoustofluidic separation methods based on other properties (such as impedance and density difference) have shown feasibility and great potential. The applications of these methods have been widely and successfully demonstrated in biological fields, including the separation of different types of cells and various bionanoparticles. While current technologies have the advantages of being contactless and biocompatible, relatively simple to operate, and having relatively high sorting efficiency, new challenges and opportunities coexist in future clinical practice, basic research, and commercialization.

Although the current acoustofluidic separation devices and platforms have shown great efficiency, many still require the use of pretreated samples, which complicates the overall process and sometimes affects sample quality. The separation of targets directly from raw samples such as whole blood can not only simplify the operation process but also establish a direct link to the relevant diseases105, thus advancing the clinical application of this technology. In vitro diagnosis (IVD) and point-of-care testing (POCT) are considered the main clinical applications of acoustic separation techniques. However, a complete solution that can handle sample preparation, target separation, and biomarker detection remains to be developed, and the all-acoustic platform holds great promise. For example, CTCs can be isolated directly from the patient’s whole blood sample using ARF, and then the CTCs can be lysed using the strong acoustic energy of the subsequent sonication module to expose DNA in the fluid. Meanwhile, the acoustic bubble microstreaming effect can be used to pump the fluid and enhance the sample-reagent mixing to facilitate the detection process. But, the throughput of current acoustofluidic devices is inadequate for the rapid processing of large amounts of samples, which is one of the basic requirements for clinical applications. Optimization of the microchannel structure to allow a higher flow rate and multiple-unit parallelization are potential solutions to this problem. However, excessive throughput sometimes leads to a decrease in separation efficiency, so it is important to strike a balance between sorting performance and throughput.

The current devices mainly focus on 2D (vertical or horizontal) separation, but 3D separation has not yet been well investigated. A possible strategy is to properly design a 3D IDT array that can focus 3D acoustic fields on the microfluidic channel, which should highly improve the precision and flexibility of particle manipulation, especially for the separation of multiple targets in complex samples. Moreover, with the development of acoustic metamaterials with unusual acoustic parameters (for example, negative refractive index)106–108, integrating these materials into microfluidic devices can manipulate and control sound waves in ways that are not possible in conventional materials, which can further improve the spatial resolution and accuracy of acoustic separation. In addition, there are still technical limitations in sorting bionanoparticles. Although sorting of submicron bioparticles can be achieved by removing the larger particles in the sample, this method cannot effectively remove smaller bioparticles. Therefore, the combination with other methods, such as the immunoaffinity method, has become a feasible technique for the specific sorting of bionanoparticles. Other novel strategies to improve the separation resolution of submicron bioparticles remain to be developed. Repeated experiments are often required to assess the performance of acoustofluidic separation, which is time-consuming and inconvenient. Some numerical simulation models can partially solve this problem109,110; however, discrepancies between simulations and experiments still exist. Recently, Talebjedi et al. integrated an artificial neural network (ANN) prediction platform and the multiobjective optimization approach to optimize the performance of acoustic separation111, showing the great potential of machine learning methods to aid in experimental design.

At present, only a few acoustofluidic technologies have been commercialized. However, these products are neither microfluidic chip-based (e.g., the Biosep cell retention device developed by Applikon for high-density perfusion processes) nor used for sorting processes (e.g., z-Movi by LUMICKS for cell avidity measurement). To the best of our knowledge, there are no commercial products for acoustofluidic separation based on microfluidic chips. The following reasons may explain this. First, the production cost is an important factor for successful commercialization. The costs of current piezoelectric-based BAW devices or IDT-based SAW devices are still too high for commercial use in disposable products. Using detachable acoustic actuation components is a feasible solution, but achieving the same level of efficiency as conventional chips is still challenging. Other strategies to reduce chip costs remain to be studied. Second, translating laboratory technology into practical instruments is still not an easy task. The operation of acoustofluidic separation requires the use of many auxiliary instruments, such as function generators, power amplifiers, and fluid control equipment. Although developments in electronic integrated circuit technology have made the high-degree integration of these components possible, the relatively specific and narrow application scenarios and thus limited market size are probably another main reason that prevents companies from investing in this technology. The development of a universal system that is compatible with different sorting chips may expand the application field and attract more business investment to develop commercialized products.

# Acknowledgements

X.W., J.R., and J.W. are grateful for the support from the National Natural Science Foundation of China (32101162, 82127801), the Guangdong Basic and Applied Basic Research Foundation (2020A1515110088), and the Shenzhen Science and Technology Innovation Commission (JCYJ20210324101401003). F.L. thanks the University of Manitoba in Canada for their support.

# Author details

1 School of Optical-Electrical and Computer Engineering, University of Shanghai for Science and Technology, Shanghai 200093, China. 2 Institute of Biomedical and Health Engineering, Shenzhen Institute of Advanced Technology, Chinese Academy of Sciences, Shenzhen 518055, China. 3 Department of Physics and Astronomy, University of Manitoba, Winnipeg, MB R3T 2N2, Canada

# Conflict of interest

The authors declare no conflict of interest.

# Received: 18 February 2022 Revised: 14 June 2022 Accepted: 19 July 2022 Published online:01 September 2022

# References

1. van Voorthuizen, E., Zwijnenburg, A., van der Meer, W. & Temmink, H. Biological black water treatment combined with membrane separation. Water Res. 42, 4334–4340 (2008).   
2. Harrison, D. J., Fluri, K., Seiler, K., Fan, Z., Effenhauser, C. S. & Manz, A. Micromachining a miniaturized capillary electrophoresis-based chemical analysis system on a chip. Science 261, 895–897 (1993).   
3. Sumi S, A. K. & Yoshida, K. Separation methods applicable to prostate cancer diagnosis and monitoring therapy. J. Chromatogr. B: Biomed. Sci. Appl. 764,   
445–455 (2001).   
4. Wu, M. et al. Acoustofluidic separation of cells and particles. Microsyst. Nanoeng. 5, 32 (2019).   
5. Scott, L. & Friedman, F. J. R. Isolation and culture of hepatic lipocytes, Kupffer ceils, and sinusoidal endothelial cells by density gradient centrifugation with Stractan. Anal. Biochem. 161, 207–218 (1987).   
6. Blackburn, Cd. W., Patel, P. D. & Gibbs, P. A. Separation and detection of salmonellae using immunomagnetic particles. Biofouling 5, 143–155 (1991).   
7. Bhagat, A. A. S. et al. Microfluidics for cell separation. Med. Biol. Eng. Comput.   
48, 999–1014 (2010).   
8. Gossett, D. R. et al. Label-free cell separation and sorting in microfluidic systems. Anal. Bioanal. Chem. 397, 3249–3267 (2010).   
9. Wyatt Shields Iv, C., Reyes, C. D. & López, G. P. Microfluidic cell sorting: A review of the advances in the separation of cells from debulking to rare cell isolation. Lab Chip 15, 1230–1249 (2015).   
10. Bruus, H. Theoretical Microfluidics (Oxford University Press, 2008).   
11. Bruus, H. Acoustofluidics 1: Governing equations in microfluidics. Lab Chip   
11, 3742–3751 (2011).   
12. Bruus, H. Acoustofluidics 2: Perturbation theory and ultrasound resonance modes. Lab Chip 12, 20–28 (2012).   
13. Bruus, H. Acoustofluidics 7: The acoustic radiation force on small particles. Lab Chip 12, 1014–1021 (2012).   
14. Patel, M. V., Nanayakkara, I. A., Simon, M. G. & Lee, A. P. Cavity-induced microstreaming for simultaneous on-chip pumping and size-based separation of cells and particles. Lab Chip 14, 3860–3872 (2014).   
15. Nam, J., Lim, H., Kim, C., Yoon Kang, J. & Shin, S. Density-dependent separation of encapsulated cells in a microfluidic channel by using a standing surface acoustic wave. Biomicrofluidics https://doi.org/10.1063/   
1.4718719 (2012).   
16. Wang, G. et al. Stiffness dependent separation of cells in a microfluidic device. PLoS One 8, e75901 (2013).   
17. Antfolk, M., Magnusson, C., Augustsson, P., Lilja, H. & Laurell, T. Acoustofluidic, label-free separation and simultaneous concentration of rare tumor cells from white blood cells. Anal. Chem. 87, 9322–9328 (2015).   
18. Tian, Z. et al. Generating multifunctional acoustic tweezers in Petri dishes for contactless, precise manipulation of bioparticles. Sci. Adv. 6, eabb0494 (2020).   
19. Wiklund, M. Acoustofluidics 12: Biocompatibility and cell viability in microfluidic acoustic resonators. Lab Chip 12, 2018–2028 (2012).   
20. Gao, Y., Wu, M., Lin, Y. & Xu, J. Acoustic microfluidic separation techniques and bioapplications: A review. Micromachines https://doi.org/10.3390/ mi11100921 (2020).   
21. Rufo, J., Cai, F., Friend, J., Wiklund, M. & Huang, T. J. Acoustofluidics for biomedical applications. Nat. Rev. Methods Primers https://doi.org/10.1038/ s43586-022-00109-7 (2022).   
22. Novotny, J., Lenshof, A. & Laurell, T. Acoustofluidic platforms for particle manipulation. Electrophoresis 43, 804–818 (2022).   
23. Li, P. & Huang, T. J. Applications of acoustofluidics in bioanalytical chemistry. Anal. Chem. 91, 757–767 (2018).   
24. Connacher, W. et al. Micro/nano acoustofluidics: Materials, phenomena, design, devices, and applications. Lab Chip 18, 1952–1996 (2018).   
25. Lenshof, A., Evander, M., Laurell, T. & Nilsson, J. Acoustofluidics 5: Building microfluidic acoustic resonators. Lab Chip 12, 684–695 (2012).   
26. Rayleigh, D. C. L. & On Waves, F. R. S. Propagated along the plane surface of an elastic solid. Proc. Lond. Math. Soc. s1-17, 4–11 (1885).   
27. Ding, X. et al. Surface acoustic wave microfluidics. Lab Chip 13, 3626–3649 (2013).   
28. Destgeer, G. & Sung, H. J. Recent advances in microfluidic actuation and micro-object manipulation via surface acoustic waves. Lab Chip 15,   
2722–2738 (2015).   
29. Wixforth, A. et al. Acoustic manipulation of small droplets. Anal. Bioanal. Chem. 379, 982–991 (2004).   
30. Riley, N. Steady streaming. Annu. Rev. Fluid Mech. 33, 43–65 (2001).   
31. Skowronek, V., Rambach, R. W., Schmid, L., Haase, K. & Franke, T. Particle deflection in a poly(dimethylsiloxane) microchannel using a propagating surface acoustic wave: Size and frequency dependence. Anal. Chem. 85,   
9955–9959 (2013).   
32. Destgeer, G. et al. Travelling surface acoustic waves microfluidics. Phys. Proc.   
70, 34–37 (2015).   
33. King, L. V. On the acoustic radiation pressure on spheres. Proc. R. Soc. Lond. Ser. A - Math. Phys. Sci. 147, 212–240 (1934).   
34. Yosioka, K., & Kawasima, Y. Acoustic radiation pressure on a compressible sphere. Acta Acust. U. Acust. 5, 167–173 (1955).   
35. Whitworth, $\mathrm { G } _ { \cdot \prime }$ Grundy, M. A. & Coakley, W. T. Transport and harvesting of suspended particles using modulated ultrasound. Ultrasonics 29, 439–444 (1991).   
36. Saeidi, $\mathrm { D } _ { \cdot \prime }$ Saghafian, $M _ { \cdot \prime }$ Haghjooy Javanmard, $\mathsf { S } _ { \cdot \prime }$ Hammarstrom, B. & Wiklund, M. Acoustic dipole and monopole effects in solid particle interaction dynamics during acoustophoresis. J. Acoust. Soc. Am. 145, 3311 (2019).   
37. Silva, G. T. & Bruus, H. Acoustic interaction forces between small particles in an ideal fluid. Phys. Rev. E https://doi.org/10.1103/PhysRevE.90.063007 (2014).   
38. Hashmi, A., Yu, G., Reilly-Collette, M., Heiman, G. & Xu, J. Oscillating bubbles: A versatile tool for lab on a chip applications. Lab Chip 12, 4216–4227 (2012).   
39. Mohapatra, A. R., Sepehrirahnama, S. & Lim, K. M. Experimental measurement of interparticle acoustic radiation force in the Rayleigh limit. Phys. Rev. E 97, 053105 (2018).   
40. Weiser, M. A. H. A., R., E. & Neppiras, E. A. Interparticle forces on red cells in a standing wave field. Apfel E. A. Neppiras, Acust. 56, 114–119 (1984).   
41. Doinikov, A. A. Acoustic radiation forces Classical theory and recent advances. Recent Res. Dev. Acoust. 1, 39–67 (2003).   
42. Simon, G. et al. Bandpass sorting of heterogeneous cells using a single surface acoustic wave transducer pair. Biomicrofluidics 15, 014105 (2021).   
43. Ma, Z., Collins, D. J. & Ai, Y. Single-actuator bandpass microparticle filtration via traveling surface acoustic waves. Colloid Interface Sci. Commun. 16, 6–9 (2017).   
44. Liu, G. et al. Separation of particles using the focused acoustic sorting chip based on the wettability treatment. AIP Adv. https://doi.org/10.1063/ 5.0042866 (2021).   
45. Liu, G. et al. Effects of two surface acoustic wave sorting chips on particles multi-level sorting. Biomed. Microdevices 21, 59 (2019).   
46. Wu, T., T, H., Chen, Y. & Liu, P. Analysis and design of focused interdigital transducers. IEEE Trans. Ultrason., Ferroelect., Freq. Control 52, 1384–1392 (2005).   
47. Sankaranarayanan, S. K. B. & R, V. Numerical analysis of wave generation and propagation in a focused surface acoustic wave device for potential microfluidics applications. IEEE Trans. Ultrason. Ferroelectr. Freq. Control 56, 631–643 (2009).   
48. Shilton, R., Tan, M. K., Yeo, L. Y. & Friend, J. R. Particle concentration and mixing in microdrops driven by focused surface acoustic waves. J. Appl. Phys. https://doi.org/10.1063/1.2951467 (2008).   
49. Collins, D. J., Neild, A. & Ai, Y. Highly focused high-frequency travelling surface acoustic waves (SAW) for rapid single-particle sorting. Lab Chip 16, 471–479 (2016).   
50. Collins, D. J. et al. Selective particle and cell capture in a continuous flow using micro-vortex acoustic streaming. Lab Chip 17, 1769–1777 (2017).   
51. Ding, X. et al. Tunable patterning of microparticles and cells using standing surface acoustic waves. Lab Chip 12, 2491–2497 (2012).   
52. Park, J. et al. Acoustothermal tweezer for droplet sorting in a disposable microfluidic chip. Lab Chip 17, 1031–1040 (2017).   
53. Destgeer, G. et al. Microchannel anechoic corner for size-selective separation and medium exchange via traveling surface acoustic waves. Anal. Chem. 87, 4627–4632 (2015).   
54. Ji, M. et al. A novel perturbed spiral sheathless chip for particle separation based on traveling surface acoustic waves (TSAW). Biosensors https://doi.org/ 10.3390/bios12050325 (2022).   
55. Ahmed, H. et al. A pumpless acoustofluidic platform for size-selective concentration and separation of microparticles. Anal. Chem. 89, 13575–13581 (2017).   
56. Collins, D. J., Alan, T. & Neild, A. Particle separation using virtual deterministic lateral displacement.Lab Chip 14, 1595–1603 (2014).   
57. Afzal, M. P., Destgeer, J., Ahmed, G., Iqrar, H., Kim,S., S. A., Kang, S., Alazzam, A., Yoon, T.-S. & Sung, H. J. Acoustomicrofluidic separation of tardigrades from raw cultures for sample preparation. Zool. J. Linn. Soc. 188, 809–819 (2020).   
58. Ahmed, H., Destgeer, G., Park, J., Jung, J. H. & Sung, H. J. Vertical hydrodynamic focusing and continuous acoustofluidic separation of particles via upward migration. Adv. Sci. 5, 1700285 (2018).   
59. Petersson, F., Aberg, $\mathsf { L } _ { \cdot } ,$ Sward-Nilsson, A.-M. & Laurell, T. Free flow acoustophoresis: Microfluidic-based mode of particle and cell separation. Anal. Chem. 79, 5117–5123 (2007).   
60. Ahmed, H., Destgeer, G., Park, J., Afzal, M. & Sung, H. J. Sheathless focusing and separation of microparticles using tilted-angle traveling surface acoustic waves. Anal. Chem. 90, 8546–8552 (2018).   
61. Li, S. et al. Standing surface acoustic wave (SSAW)-based cell washing. Lab Chip 15, 331–338 (2015).   
62. Liu, Z. et al. Theory of acoustophoresis in counterpropagating surface acoustic wave fields for particle separation. Phys. Rev. E https://doi.org/ 10.1103/PhysRevE.103.033104 (2021).   
63. Ding, X. et al. Cell separation using tilted-angle standing surface acoustic waves. Proc. Natl Acad. Sci. USA 111, 12992–12997 (2014).   
64. Wu, F. et al. An enhanced tilted-angle acoustofluidic chip for cancer cell manipulation. IEEE Electron Device Lett. 42, 577–580 (2021).   
65. Chang, L.-Y., Liao, T.-W., Ye, M.-L. & Juang, Y.-J. Utilization of n-dodecane as coupling layer for reusable acoustofluidic microchips. J. Micromech. Microeng. https://doi.org/10.1088/1361-6439/ac2f51 (2021).   
66. Guo, F. et al. Reusable acoustic tweezers for disposable devices. Lab Chip 15,   
4517–4523 (2015).   
67. Qian, J., Ren, J., Liu, Y., Lam, R. H. W. & Lee, J. E. A two-chip acoustofluidic particle manipulation platform with a detachable and reusable surface acoustic wave device. Analyst 145, 7752–7758 (2020).   
68. Ma, Z., Collins, D. J. & Ai, Y. Detachable acoustofluidic system for particle separation via a traveling surface acoustic wave. Anal. Chem. 88, 5316–5323 (2016).   
69. Xie, Y. et al. Acoustic cell separation based on density and mechanical properties. J. Biomech. Eng. 142, 031005 (2020).   
70. Augustsson, P., Karlsen, J. T., Su, H. W., Bruus, H. & Voldman, J. Iso-acoustic focusing of cells for size-insensitive acousto-mechanical phenotyping. Nat. Commun. 7, 11556 (2016).   
71. Karthick, S., Pradeep, P. N., Kanchana, P. & Sen, A. K. Acoustic impedancebased size-independent isolation of circulating tumour cells from blood using acoustophoresis. Lab Chip 18, 3802–3813 (2018).   
72. Jo, M. C. & Guldiken, R. Active density-based separation using standing surface acoustic waves. Sens. Actuators A: Phys. 187, 22–28 (2012).   
73. Ma, Z., Collins, D. J., Guo, J. & Ai, Y. Mechanical properties based particle separation via traveling surface acoustic wave. Anal. Chem. 88, 11844–11851 (2016).   
74. Liu, G. et al. Continuous separation of particles with different densities based on standing surface acoustic waves. Sensors Actuators A: Phys. https://doi.org/   
10.1016/j.sna.2022.113589 (2022).   
75. Zhou, Y., Ma, Z. & Ai, Y. Hybrid microfluidic sorting of rare cells based on high throughput inertial focusing and high accuracy acoustic manipulation. RSC Adv. 9, 31186–31195 (2019).   
76. Li, P. et al. Acoustic separation of circulating tumor cells. Proc. Natl Acad. Sci. USA 112, 4970–4975 (2015).   
77. Lu, X. et al. Parallel label‐free isolation of cancer cells using arrays of acoustic microstreaming traps. Adv. Mater. Technol. https://doi.org/10.1002/ admt.201800374 (2018).   
78. Wu, Z. et al. The acoustofluidic focusing and separation of rare tumor cells using transparent lithium niobate transducers. Lab Chip 19, 3922–3930 (2019).   
79. Antfolk, M., Kim, S. H., Koizumi, S., Fujii, T. & Laurell, T. Label-free single-cell separation and imaging of cancer cells using an integrated microfluidic system. Sci. Rep. 7, 46507 (2017).   
80. Faridi, M. A. et al. MicroBubble activated acoustic cell sorting. Biomed. Microdevices 19, 23 (2017).   
81. Iranmanesh, I., Ramachandraiah, H., Russom, A. & Wiklund, M. On-chip ultrasonic sample preparation for cell based assays. RSC Adv. 5, 74304–74311 (2015).   
82. Bai, X. et al. Postoperative evaluation of tumours based on label-free acoustic separation of circulating tumour cells by microstreaming. Lab Chip 21,   
2721–2729 (2021).   
83. Ai, Y., Sanders, C. K. & Marrone, B. L. Separation of Escherichia coli bacteria from peripheral blood mononuclear cells using standing surface acoustic waves. Anal. Chem. 85, 9126–9134 (2013).   
84. Li, S. et al. Acoustofluidic bacteria separation. J. Micromech. Microeng. https:// doi.org/10.1088/1361-6439/27/1/015031 (2017).   
85. Ning, S. et al. A microfluidic chip with a serpentine channel enabling highthroughput cell separation using surface acoustic waves. Lab Chip 21,   
4608–4617 (2021).   
86. Wu, M. et al. High-throughput cell focusing and separation via acoustofluidic tweezers. Lab Chip 18, 3003–3010 (2018).   
87. Dow, P., Kotz, K., Gruszka, S., Holder, J. & Fiering, J. Acoustic separation in plastic microfluidics for rapid detection of bacteria in blood using engineered bacteriophage. Lab Chip 18, 923–932 (2018).   
88. Van Assche, D. et al. Gradient acoustic focusing of sub-micron particles for separation of bacteria from blood lysate. Sci. Rep. 10, 3670 (2020).   
89. Liu, S. C., Yoo, P. B., Garg, N., Lee, A. P. & Rasheed, S. A microfluidic device for blood plasma separation and fluorescence detection of biomarkers using acoustic microstreaming. Sensors Actuators A: Phys. https://doi.org/10.1016/ j.sna.2020.112482 (2021).   
90. Nam, J., Lim, H., Kim, D. & Shin, S. Separation of platelets from whole blood using standing surface acoustic waves in a microchannel. Lab Chip 11, 3361–3364 (2011).   
91. Chen, Y. et al. High-throughput acoustic separation of platelets from whole blood. Lab Chip 16, 3466–3472 (2016).   
92. Vemula, S. V. et al. Current approaches for diagnosis of influenza virus infections in humans. Viruses 8, 96 (2016).   
93. Jung, B., Fisher, K., Ness, K. D., Rose, K. A. & Mariella, R. P. Jr Acoustic particle filter with adjustable effective pore size for automated sample preparation. Anal. Chem. 80, 8447–8452 (2008).   
94. Fong, E. J. et al. Acoustic focusing with engineered node locations for highperformance microfluidic particle separation. Analyst 139, 1192–1200 (2014).   
95. Liu, Z. et al. Fluorescent labeling based acoustofluidic screening of Japanese encephalitis virus. Sensors Actuators B: Chem. https://doi.org/10.1016/ j.snb.2020.128649 (2020).   
96. Neumann, J. et al. Transport, separation, and accumulation of proteins on supported lipid bilayers. Nano Lett. 10, 2903–2908 (2010).   
97. Ahmad, R. et al. Acoustic wave-driven functionalized particles for aptamerbased target biomolecule separation. Anal. Chem. 89, 13313–13319 (2017).   
98. Li, L. et al. Rapid capture of biomolecules from blood via stimuli-responsive elastomeric particles for acoustofluidic separation. Analyst 145, 8087–8096 (2021).   
99. Afzal, M. et al. Acoustofluidic separation of proteins using aptamerfunctionalized microparticles. Anal. Chem. 93, 8309–8317 (2021).   
100. Kalluri, R. & LeBleu, V. S. The biology, function, and biomedical applications of exosomes. Science https://doi.org/10.1126/science.aau6977 (2020).   
101. Lee, K., Shao, H., Weissleder, R. & Lee, H. Acoustic purification of extracellular microvesicles. ACS Nano 9, 2321–2327 (2015).   
102. Wu, M. et al. Isolation of exosomes from whole blood by integrating acoustics and microfluidics. Proc. Natl Acad. Sci. USA 114, 10584–10589 (2017).   
103. Wang, Z. et al. Acoustofluidic salivary exosome isolation: A liquid biopsy compatible approach for human papillomavirus-associated oropharyngeal cancer detection. J. Mol. Diagn. 22, 50–59 (2020).   
104. Wang, Z. et al. Acoustofluidic separation enables early diagnosis of traumatic brain injury based on circulating exosomes. Microsyst. Nanoeng. https:// doi.org/10.1038/s41378-021-00244-3 (2021).   
105. Hao, N. et al. Acoustofluidic multimodal diagnostic system for Alzheimer’s disease. Biosens. Bioelectron. 196, 113730 (2022).   
106. Melde, K., Mark, A. G., Qiu, T. & Fischer, P. Holograms for acoustics. Nature 537, 518–522 (2016).   
107. Cummer, S. A., Christensen, J. & Alù, A. Controlling sound with acoustic metamaterials. Nat. Rev. Mater. https://doi.org/10.1038/natrevmats.2016.1 (2016).   
108. Memoli, G. et al. Metamaterial bricks and quantization of meta-surfaces. Nat. Commun. 8, 14608 (2017).   
109. Altay, R., Yapici, M. K. & Kosar, A. A hybrid spiral microfluidic platform coupled with surface acoustic waves for circulating tumor cell sorting and separation: A numerical study. Biosensors https://doi.org/10.3390/bios12030171 (2022).   
110. Ashkezari, A. H. K., Dizani, M. & Shamloo, A. Integrating hydrodynamic and acoustic cell separation in a hybrid microfluidic device: a numerical analysis. Acta Mech. 233, 1881–1894 (2022).   
111. Talebjedi, B. et al. Neural network-based optimization of an acousto microfluidic system for submicron bioparticle separation. Front. Bioeng. Biotechnol. 10, 878398 (2022).